<?php

namespace Vtlabs\Ride\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Ride\Http\Resources\VehicleTypeResource;

class RideResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'address_from' => $this->address_from,
            'longitude_from' => $this->longitude_from,
            'latitude_from' => $this->latitude_from,
            'address_to' => $this->address_to,
            'longitude_to' => $this->longitude_to,
            'latitude_to' => $this->latitude_to,
            'ride_start_at' => $this->ride_start_at,
            'ride_ends_at' => $this->ride_ends_at,
            'ride_on' => $this->ride_on,
            'is_scheduled' => $this->is_scheduled,
            'estimated_pickup_distance' => $this->estimated_pickup_distance,
            'estimated_pickup_time' => $this->estimated_pickup_time,
            'estimated_distance' => $this->estimated_distance,
            'final_distance' => $this->final_distance,
            'estimated_time' => $this->estimated_time,
            'final_time' => $this->final_time,
            'estimated_fare' => $this->estimated_fare,
            'final_fare' => $this->final_fare,
            'cancelled_by' => $this->cancelled_by,
            'cancel_reason' => $this->cancel_reason,
            'status' => $this->status,
            'vehicle_type' => new VehicleTypeResource($this->vehicleType),
            'user' => new UserResource($this->user),
            'driver' => new DriverResource($this->driver),
            'payment' => new PaymentResource($this->payment),
        ];
    }
}
