<?php

namespace Vtlabs\Ride\Http\Resources;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Ride\Http\Resources\VehicleTypeResource;

class DriverResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'is_verified' => $this->is_verified,
            'is_online' => $this->is_online,
            'is_riding' => $this->is_riding,
            'current_latitude' => $this->current_latitude,
            'current_longitude' => $this->current_longitude,
            'distance_remaining' => $this->distance_remaining,
            'vehicle_type' => new VehicleTypeResource($this->vehicleType),
            'user' => new UserResource($this->user),
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
        ];
    }
}
