<?php

namespace Vtlabs\Ride\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Ride\Models\VehicleType;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Core\Services\GoogleDistanceService;
use Vtlabs\Ride\Http\Resources\VehicleTypeResource;


class VehicleTypeController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'latitude_from' => 'sometimes|numeric',
            'longitude_from' => 'required_with:latitude_from|numeric',
            'latitude_to' => 'required_with:latitude_from|numeric',
            'longitude_to' => 'required_with:latitude_from|numeric'
        ]);
        $vehicleTypes = VehicleType::all();
        $fares = [];

        if ($request->latitude_from) {
            try {
                $googleDistanceService = new GoogleDistanceService($request->latitude_from, $request->longitude_from, $request->latitude_to, $request->longitude_to);
                [$distance, $time] = $googleDistanceService->distanceAndTime();
                foreach ($vehicleTypes as $vehicleType) {
                    $vehicleType->estimated_fare = $vehicleType->calculateFare($distance, $time);
                    array_push($fares, ["vehicle_type_id" => $vehicleType->id, "estimated_fare" => $vehicleType->calculateFare($distance, $time)]);
                }
            } catch (\Exception $ex) {
                return response()->json(["message" => $ex->getMessage()], 400);
            }
        }

        return response()->json(["vehicle_types" => VehicleTypeResource::collection($vehicleTypes), "fares" => $fares]);
    }
}
