<?php

namespace Vtlabs\Ride\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Ride\Models\Driver;
use Rennokki\Plans\Models\PlanModel;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Payment\Http\Resources\PaymentResource;

/**
 * @group  Media
 *
 * APIs for subscription plans
 */
class PlanController extends Controller
{
    public function index()
    {
        return response()->json(PlanModel::with('features')->get());
    }

    public function purchasePlan(Driver $driver, PlanModel $plan, Request $request)
    {
        $request->validate([
            'payment_method_slug' => 'required|exists:payment_methods,slug'
        ]);

        // payment
        $payment = $driver->user->createPayment($plan, $plan->price, $request->payment_method_slug);

        return new PaymentResource($payment);
    }
}
