<?php

namespace Vtlabs\Ride\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Ride\Http\Resources\Admin\VehicleTypeAdminResource;
use Vtlabs\Ride\Models\VehicleType;

class VehicleTypeController extends Controller
{
    public function index(Request $request)
    {
        return VehicleTypeAdminResource::collection(VehicleType::latest()->paginate());
    }

    public function show(VehicleType $vehicletype)
    {
        return new VehicleTypeAdminResource($vehicletype);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'base_fare' => 'required|numeric',
            'time_charges_per_minute' => 'required|numeric',
            'other_charges' => 'required|numeric',
            'seats' => 'required|numeric',
            'meta' => 'sometimes|json|nullable'
        ]);

        request()->merge([
            'meta' => $request->meta ? json_decode($request->met, true) : null
        ]);

        $vehicletype = new VehicleType();
        $vehicletype->fill($request->only([
            'title', 'base_fare', 'time_charges_per_minute', 'other_charges', 'seats', 'meta'
        ]));
        $vehicletype->save();

        return new VehicleTypeAdminResource($vehicletype->refresh());
    }

    public function update(VehicleType $vehicletype, Request $request)
    {
        $request->validate([
            'title' => 'required',
            'base_fare' => 'required|numeric',
            'time_charges_per_minute' => 'required|numeric',
            'other_charges' => 'required|numeric',
            'seats' => 'required|numeric',
            'meta' => 'sometimes|json|nullable'
        ]);

        request()->merge([
            'meta' => $request->meta ? json_decode($request->meta, true) : null
        ]);

        $vehicletype->fill($request->only([
            'title', 'base_fare', 'time_charges_per_minute', 'other_charges', 'seats', 'meta'
        ]));
        $vehicletype->save();

        return new VehicleTypeAdminResource($vehicletype->refresh());
    }


    public function destroy(VehicleType $vehicletype, Request $request)
    {
        Gate::authorize('delete');

        $vehicletype->delete();

        return response()->json([], 204);
    }
}
