<?php

namespace Vtlabs\Ride\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Ride\Models\Ride;
use Illuminate\Validation\Rule;
use Vtlabs\Ride\Filters\RideFilter;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Ride\Http\Resources\Admin\RideAdminResource;

class RideController extends Controller
{
    public function index(Request $request)
    {
        $rides = Ride::filter($request->all(), RideFilter::class)->latest();

        return RideAdminResource::collection($rides->paginate());
    }

    public function show(Ride $ride)
    {
        return new RideAdminResource($ride);
    }

    public function update(Ride $ride, Request $request)
    {
        $request->validate([
            'status' => ['required', Rule::in(config('vtlabs_ride.ride.status_list', []))]
        ]);

        if ($ride->status !== $request->status) {
            $lastStatus = $ride->status;

            $ride->setStatus($request->status);

            $ride->save();
        }

        return new RideAdminResource($ride->fresh());
    }

    public function destroy(Ride $ride, Request $request)
    {
        Gate::authorize('delete');

        $ride->delete();

        return response()->json([], 200);
    }
}
