<?php

namespace Vtlabs\Ride\Filters;

use EloquentFilter\ModelFilter;

class RideFilter extends ModelFilter
{
    public function user($id)
    {
        return $this->where('user_id', $id);
    }

    public function driver($id)
    {
        return $this->where('driver_id', $id);
    }

    public function status($status)
    {
        return $this->currentStatus($status);
    }

    public function upcoming($upcoming)
    {
        return $this->currentStatus(['pending', 'accepted', 'arrived', 'onway', 'ongoing']);
    }
}
