<?php

namespace Vtlabs\Ride\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;
use Vtlabs\Ride\Models\DriverRideLog;

class DriverFilter extends ModelFilter
{
    public function setup()
    {
        // filter blank profiles and non verified vendors
        if (!CoreHelper::isAdmin()) {
            $this->where('is_verified', true);
        }

        // filter driver based on location
        $distanceLimit = CoreHelper::settingsAsDictionary()['nearby_driver_distance'] ?? 8000;

        if ($this->input('long') && $this->input('lat')) {
            $subqueryDistance = "ST_Distance_Sphere(Point(current_longitude,"
                . " current_latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " as distance";

            $subqueryDistanceWhere = "ST_Distance_Sphere(Point(current_longitude,"
                . " current_latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " < " . $distanceLimit;

            $this->select('*', DB::raw($subqueryDistance))
                ->whereRaw($subqueryDistanceWhere);
        }
    }

    public function vehicleType($vehicleTypeId)
    {
        return $this->where('vehicle_type_id', $vehicleTypeId);
    }

    public function isOnline($isOnline)
    {
        return $this->where('is_online', 1);
    }

    public function riding($riding)
    {
        return $this->where('is_riding', $riding);
    }

    public function excludePastDriversForRide($ride)
    {
        $excludeDriverIds = DriverRideLog::where('ride_id', $ride)->get()->pluck('driver_id')->toArray();
        return $this->whereNotIn('id', $excludeDriverIds);
    }
}
