<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Ride\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/ride')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('drivers', 'DriverController');
            Route::apiResource('vehicletypes', 'VehicleTypeController');
            Route::apiResource('rides', 'RideController');
        });
    });

    // app/web api
    Route::prefix('ride')->group(function () {

        // vehicle types
        Route::get('vehicle-types', 'VehicleTypeController@index');

        // driver
        Route::get('drivers/list', 'DriverController@index');
        Route::get('drivers/{driver}', 'DriverController@show');
        Route::get('drivers/ratings/summary/{driver}', 'DriverController@ratingSummary');

        // plan 
        Route::get('plans', 'PlanController@index');

        Route::middleware('auth:api')->group(function () {

            // driver
            Route::get('drivers', 'DriverController@showMyProfile');
            Route::put('drivers', 'DriverController@update');
            Route::post('drivers/ratings/{driver}', 'DriverController@ratingStore');

            // rides
            Route::get('rides', 'RideController@index');
            Route::post('rides', 'RideController@store');
            Route::post('/rides/fare-estimate', 'RideController@fareEstimate');
            Route::post('/rides/{ride}/cancel', 'RideController@cancel');
            Route::put('/rides/{ride}', 'RideController@update');

            // plans
            Route::post('plans/{driver}/{plan}', 'PlanController@purchasePlan');
        });
    });
});
