<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRideDriversRidesLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_drivers_rides_logs', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('ride_id')->unsigned();
            $table->foreign('ride_id')->references('id')->on('ride_rides')->onDelete('cascade');

            $table->integer('driver_id')->unsigned();
            $table->foreign('driver_id')->references('id')->on('ride_drivers')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ride_drivers_rides_logs', function (Blueprint $table) {
            $table->dropForeign(['driver_id']);
            $table->dropForeign(['ride_id']);
        });

        Schema::dropIfExists('ride_drivers_rides_logs');
    }
}
