<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRideRidesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_rides', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();

            $table->enum('type', ['ride', 'intercity', 'courier'])->nullable();

            $table->string('address_from');
            $table->decimal('longitude_from', 15, 7);
            $table->decimal('latitude_from', 15, 7);
            $table->string('address_to');
            $table->decimal('longitude_to', 15, 7);
            $table->decimal('latitude_to', 15, 7);
            $table->dateTime('ride_start_at')->nullable();
            $table->dateTime('ride_ends_at')->nullable();
            $table->dateTime('ride_on')->nullable();
            $table->boolean('is_scheduled')->default(false);
            $table->boolean('is_scheduled_ready')->default(false); // check if scheduled ride is ready i.e it's scheduled time arrived
            $table->double('estimated_pickup_distance')->nullable();
            $table->double('estimated_pickup_time')->nullable();
            $table->double('estimated_distance')->nullable();
            $table->double('final_distance')->nullable();
            $table->double('estimated_time')->nullable();
            $table->double('final_time')->nullable();
            $table->double('estimated_fare')->nullable();
            $table->double('final_fare')->nullable();
            $table->enum('cancelled_by', ['customer', 'driver'])->nullable();
            $table->string('cancel_reason')->nullable();
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('vehicle_type_id')->unsigned()->nullable(); // null in case of courier
            $table->foreign('vehicle_type_id')->references('id')->on('ride_vehicle_types')->onDelete('cascade');

            $table->integer('driver_id')->unsigned();
            $table->foreign('driver_id')->references('id')->on('ride_drivers')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
