<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRideDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_drivers', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->boolean('is_online')->default(false);
            $table->boolean('is_riding')->default(false);
            $table->decimal('current_latitude', 15, 7)->default(0.0);
            $table->decimal('current_longitude', 15, 7)->default(0.0);
            $table->integer('distance_remaining')->default(0); // distance remaining for current ride
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('vehicle_type_id')->unsigned()->nullable();
            $table->foreign('vehicle_type_id')->references('id')->on('ride_vehicle_types')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ride_drivers');
    }
}
