<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRideVehicleTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_vehicle_types', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->json('title')->nullable();
            $table->float('base_fare');
            $table->float('time_charges_per_minute')->default(0.0);
            $table->float('other_charges')->default(0.0);
            $table->integer('seats')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ride_vehicle_types');
    }
}
