<?php

namespace Vtlabs\Provider\Providers;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Payment\Events\PaymentUpdated;
use Vtlabs\Provider\Events\NewAppointment;
use Vtlabs\Provider\Events\UpdateAppointment;
use Vtlabs\Provider\Listeners\LoggedInListener;
use Vtlabs\Provider\Listeners\RoleAssignedListener;
use Vtlabs\Provider\Listeners\PaymentUpdatedListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Vtlabs\Provider\Listeners\NewAppointmentListener;
use Vtlabs\Provider\Listeners\UpdateAppointmentListener;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        PaymentUpdated::class => [PaymentUpdatedListener::class],
        NewAppointment::class => [NewAppointmentListener::class],
        UpdateAppointment::class => [UpdateAppointmentListener::class]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
