<?php

namespace Vtlabs\Provider\Models;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Provider\Models\ProviderProfile;

class Referral extends Model
{
    protected $table = 'user_provider_referrals';

    protected $guarded = [];

    public $timestamps = false;
    
    public static function generate($userId, $providerId)
    {
        $referral = null;
        while (1) {
            $referralCode = Str::random(8);
            if (!Referral::where('referral_code', $referralCode)->exists()) {
                $referral = Referral::create([
                    'referral_code' => $referralCode,
                    'user_id' => $userId,
                    'provider_profile_id' => $providerId
                ]);
                break;
            }
        }

        return $referral;
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function providerProfile()
    {
        $this->belongsTo(ProviderProfile::class);
    }
}
