<?php

namespace Vtlabs\Provider\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Rennokki\Plans\Traits\HasPlans;
use Vtlabs\Category\Models\Category;
use Rennokki\Rating\Traits\CanBeRated;
use Illuminate\Database\Eloquent\Model;
use Rennokki\Rating\Contracts\Rateable;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Appointment\Contracts\Appointee;
use Vtlabs\Appointment\Traits\CanBeAppointed;
use Vtlabs\Provider\Models\ProviderAvailability;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class ProviderProfile extends Model implements Appointee, Rateable, HasMedia
{
    use Filterable,
        Favoriteable,
        CoreHasMediaTrait,
        HasTranslations,
        CanBeAppointed,
        HasPlans,
        CanBeRated;

    protected $table = 'provider_profiles';

    protected $guarded = [];

    protected $casts = [
        'name' => 'json',
        'details' => 'json',
        'meta' => 'json',
        'longitude' => 'float',
        'latitude' => 'float',
        'is_verified' => 'integer',
        'fee' => 'float'
    ];

    public $translatable = ['name', 'details'];

    public static function findByUser($userId)
    {
        return Providerprofile::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'provider_profiles_categories', 'provider_profile_id', 'category_id')->withPivot("fee");
    }

    public function subcategories()
    {
        return $this->belongsToMany(Category::class, 'provider_profiles_subcategories', 'provider_profile_id', 'category_id')->withPivot("fee");
    }

    public function availabilities()
    {
        return $this->hasMany(ProviderAvailability::class, 'provider_profile_id');
    }
}
