<?php

namespace Vtlabs\Provider\Listeners;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Models\Notification;
use Vtlabs\Provider\Models\ProviderProfile;
use Vtlabs\Provider\Events\UpdateAppointment;

class UpdateAppointmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function handle(UpdateAppointment $event)
    {
        $provider = ProviderProfile::find($event->appointment->appointee_id);
        $user = User::find($event->appointment->appointer_id);

        $category = isset($event->appointment->meta['category']) ? $event->appointment->meta['category'] : null;

        Notification::create([
            'type' => 'appointment',
            'text' => 'Appointment status has been updated to ' . $event->appointment->status,
            'user_id' => $user->id,
            'from_user_id' => $provider->user->id,
            'meta' => ['from_user_name' => $provider->user->name, 'from_user_image' => $provider->user->image_url, 'category' => $category]
        ]);

        $user->sendPushNotification(
            'customer',
            __('vtlabs_provider::messages.notification_update_appointment_title', ['provider' => $provider->user->name, 'status' => $event->appointment->status]),
            __('vtlabs_provider::messages.notification_update_appointment_body', ['status' => $event->appointment->status])
        );

        return true;
    }
}
