<?php

namespace Vtlabs\Provider\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Provider\Models\ProviderProfile;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('provider', $event->roles)) {
            if (!ProviderProfile::where('user_id', $event->user->id)->exists()) {
                ProviderProfile::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
