<?php

namespace Vtlabs\Provider\Listeners;

use Vtlabs\Core\Models\User\User;
use Rennokki\Plans\Models\PlanModel;
use Vtlabs\Payment\Events\PaymentUpdated;
use Vtlabs\Provider\Models\ProviderProfile;

class PaymentUpdatedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  Registered $event
     * @return void
     */
    public function handle(PaymentUpdated $event)
    {
        $payment = $event->payment;

        // we need to subscribe plan according to payment status
        if ($payment->payable_type == 'Rennokki\Plans\Models\PlanModel' && $payment->payer_type == User::class) {
            if (ProviderProfile::where('user_id', $payment->payer_id)->exists()) {
                if ($payment->status == 'paid') {
                    $plan = PlanModel::find($payment->payable_id);
                    $provider = ProviderProfile::where('user_id', $payment->payer_id)->first();
                    if ($provider->hasActiveSubscription()) {
                        $provider->cancelCurrentSubscription();
                    }
                    $provider->subscribeTo($plan, $plan->duration);

                    $provider->plan_sort_order = $plan->sort_order;

                    $provider->save();
                }
            }
        }

        return true;
    }
}
