<?php

namespace Vtlabs\Provider\Listeners;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Models\Notification;
use Vtlabs\Provider\Events\NewAppointment;
use Vtlabs\Provider\Models\ProviderProfile;

class NewAppointmentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function handle(NewAppointment $event)
    {
        $provider = ProviderProfile::find($event->appointment->appointee_id);
        $user = User::find($event->appointment->appointer_id);

        $category = isset($event->appointment->meta['category']) ? $event->appointment->meta['category'] : null;

        Notification::create([
            'type' => 'appointment',
            'text' => $user->name . ' request for your service',
            'user_id' => $provider->user_id,
            'from_user_id' => $user->id,
            'meta' => ['from_user_image' => $user->image_url, 'category' => $category]
        ]);

        $provider->user->sendPushNotification(
            'provider',
            __('vtlabs_provider::messages.notification_new_appointment_title', ['id' => $event->appointment->id]),
            __('vtlabs_provider::messages.notification_new_appointment_body')
        );

        return true;
    }
}
