<?php

namespace Vtlabs\Provider\Http\Resources;

use Vtlabs\Provider\Models\ProviderProfile;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Provider\Http\Resources\ProviderProfileResource;

class ProviderRatingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'rating' => $this->pivot->rating,
            'review' => $this->pivot->review,
            'created_at' => $this->pivot->created_at,
            'user' => new UserResource($this->resource),
            'provider' => new ProviderProfileResource(ProviderProfile::find($this->pivot->rateable_id)),
            'meta' => json_decode($this->pivot->meta)
        ];
    }
}