<?php

namespace Vtlabs\Provider\Http\Resources;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Provider\Http\Resources\ProviderAvailabilityResource;
use Vtlabs\Provider\Http\Resources\ProviderProfileCategoryResource;
use Vtlabs\Provider\Http\Resources\ProviderProfileSubcategoryResource;

class ProviderProfileResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_translations' => $this->getTranslations('name'),
            'details' => $this->details,
            'details_translations' => $this->getTranslations('details'),
            'meta' => $this->meta,
            'fee' => $this->fee,
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'distance' => $this->distance,
            'is_verified' => $this->is_verified,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'user_id' => $this->user_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'categories' => ProviderProfileCategoryResource::collection($this->categories),
            'subcategories' => ProviderProfileSubcategoryResource::collection($this->subcategories),
            'availability' => ProviderAvailabilityResource::collection($this->availabilities),
            'user' => new UserResource($this->user),
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavorited(),
            'plan' => $this->hasActiveSubscription() ? $this->activeSubscription() : null,
            'plan_sort_order' => $this->plan_sort_order
        ];
    }
}
