<?php

namespace Vtlabs\Provider\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Provider\Models\Referral;
use Vtlabs\Provider\Models\ReferralLog;
use Vtlabs\Core\Http\Controllers\Controller;

class ReferralController extends Controller
{
    public function show(Request $request)
    {
        $request->validate([
            'provider_profile_id' => 'required'
        ]);
        $referral = Referral::where('user_id', Auth::id())->where('provider_profile_id', $request->provider_profile_id)->first();
        if (!$referral) {
            $referral = Referral::generate(Auth::id(), $request->provider_profile_id);
        }
        return response()->json(['referral_code' => $referral->referral_code]);
    }

    public function checkForDiscount(Request $request) 
    {
        $request->validate([
            'provider_profile_id' => 'required'
        ]);

        $discountedService = 0;
        $referral = Referral::where('user_id', Auth::id())->where('provider_profile_id', $request->provider_profile_id)->first();
        $settings = CoreHelper::settingsAsDictionary();
        if($referral && $referral->usage_counter / $settings['provider_referral_count'] >= 1) {
            $discountedService = 1;
        }

        return response()->json(['discounted_service' => $discountedService]);
    }
}
