<?php

namespace Vtlabs\Provider\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Rennokki\Plans\Models\PlanModel;
use Rennokki\Plans\Models\PlanUsageLog;
use Vtlabs\Provider\Models\ProviderProfile;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Payment\Http\Resources\PaymentResource;

/**
 * @group  Media
 *
 * APIs for subscription plans
 */
class PlanController extends Controller
{
    public function index()
    {
        return response()->json(PlanModel::with('features')->get());
    }

    public function purchasePlan(ProviderProfile $providerProfile, PlanModel $plan, Request $request)
    {
        $request->validate([
            'payment_method_slug' => 'required|exists:payment_methods,slug'
        ]);

        // payment
        $payment = $providerProfile->user->createPayment($plan, $plan->price, $request->payment_method_slug);

        return new PaymentResource($payment);
    }

    public function planDetails(ProviderProfile $providerProfile)
    {
        $leadsRemainingForToday = null;

        if($providerProfile->hasActiveSubscription()) {
            $subscription = $providerProfile->activeSubscription();
            $leadsUsedToday = PlanUsageLog::getTodayUsage($subscription->id);
            $limit = $subscription->features()->code('leads_per_day')->first()->limit/30;
            $leadsRemainingForToday = $limit - $leadsUsedToday;
        }

        return response([
            "subscription" => $providerProfile->activeSubscription(),
            "active" => $providerProfile->hasActiveSubscription(),
            "leads_remaining_for_today" => $leadsRemainingForToday
        ]);
    }
}
