<?php

namespace Vtlabs\Provider\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;

class ProviderFilter extends ModelFilter
{
    public function setup()
    {
        if ($this->input('long') && $this->input('lat')) {
            $settings = CoreHelper::settingsAsDictionary();

            $subqueryDistance = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " as distance";

            $subqueryDistanceWhere = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " < " . $settings['delivery_distance'];

            $this->select('*', DB::raw($subqueryDistance))
                ->whereRaw($subqueryDistanceWhere)->orderBy('distance');
        }
    }

    public function category($id)
    {
        return $this->whereHas('categories', function ($query) use ($id) {
            return $query->where('id', $id)->orWhere('slug', $id);
        });
    }

    public function subcategory($id)
    {
        return $this->whereHas('subcategories', function ($query) use ($id) {
            return $query->where('id', $id)->orWhere('slug', $id);
        });
    }
}
