<?php

namespace Vtlabs\Provider\Filters;

use EloquentFilter\ModelFilter;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Provider\Models\ProviderProfile;
use Carbon\Carbon;

class AppointmentFilter extends ModelFilter
{
    public function setup()
    {
        $this->where('appointer_type', User::class)
            ->where('appointee_type', ProviderProfile::class);
    }

    public function appointer($id)
    {
        return $this->where('appointer_id', $id);
    }

    public function appointee($id)
    {
        return $this->where('appointee_id', $id);
    }

    public function upcoming($upcoming) 
    {
        return $this->where('date', '>=', Carbon::now()->toDateString())->currentStatus(['pending', 'accepted', 'onway', 'ongoing']);
    }

    public function past($past) 
    {
        return $this->currentStatus(['complete', 'cancelled', 'rejected']);
    }
}
