<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Provider\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/provider')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('providerprofiles', 'ProviderProfileController');
            Route::apiResource('appointments', 'AppointmentController');
            Route::apiResource('plans', 'PlanController');

            Route::get('/dashboard/appointment-analytics', 'DashboardController@appointmentAnalytics');
        });
    });

    // app/web api
    Route::prefix('provider')->group(function () {

        // plan 
        Route::get('plans', 'PlanController@index');

        Route::get('profile/list', 'ProviderProfileController@index');
        Route::get('profile/user/{user}', 'ProviderProfileController@showProfileByUser');
        Route::get('profile/{profile}', 'ProviderProfileController@show');
        Route::get('profile/schedule/{profile}', 'ProviderProfileController@schedule');

        Route::middleware('auth:api')->group(function () {
            // provider
            Route::get('profile', 'ProviderProfileController@showMyProfile');
            Route::put('profile', 'ProviderProfileController@update');
            Route::get('profile/ratings/{providerProfile}', 'ProviderProfileController@ratingList');
            Route::post('profile/ratings/{providerProfile}', 'ProviderProfileController@ratingStore');
            Route::get('profile/ratings/summary/{providerProfile}', 'ProviderProfileController@ratingSummary');
            Route::get('profile/favourites/list', 'ProviderProfileController@favourites');
            Route::post('profile/favourites/{providerProfile}', 'ProviderProfileController@toggleFavourite');

            // appointment
            Route::get('appointments', 'AppointmentController@index');
            Route::post('appointments/{providerProfile}', 'AppointmentController@store');
            Route::put('appointments/{appointment}', 'AppointmentController@update');

            // plan
            Route::get('plans/{providerProfile}/details', 'PlanController@planDetails');
            Route::post('plans/{providerProfile}/{plan}', 'PlanController@purchasePlan');

            // referral
            Route::get('referral', 'ReferralController@show');
            Route::get('referral/check-discount', 'ReferralController@checkForDiscount');
        });
    });
});
