<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserProviderReferralsTable extends Migration
{
    public function up()
    {
        Schema::create('user_provider_referrals', function (Blueprint $table) {
            $table->increments('id');
            $table->string('referral_code', 8)->unique();
            $table->integer('usage_counter')->unsigned()->default(0);
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->integer('provider_profile_id')->unsigned();
            $table->foreign('provider_profile_id')->references('id')->on('provider_profiles')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('user_provider_referral_logs', function (Blueprint $table) {
            $table->increments('id');
            
            $table->integer('referral_id')->unsigned();
            $table->foreign('referral_id')->references('id')->on('user_provider_referrals')->onDelete('cascade');
            
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }
    
    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down()
    {
        Schema::table('user_provider_referral_logs', function (Blueprint $table) {
            $table->dropForeign(['referral_id']);
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('user_provider_referral_logs');

        Schema::table('user_provider_referrals', function (Blueprint $table) {
            $table->dropForeign(['provider_profile_id']);
            $table->dropForeign(['category_id']);
        });
        Schema::dropIfExists('user_provider_referrals');
    }
}
