<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProviderAvailabilitiesTable extends Migration
{
    public function up()
    {
        Schema::create('provider_availabilities', function (Blueprint $table) {
            $table->increments('id');
            $table->enum('days', ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat']);
            $table->time('from');
            $table->time('to');
            $table->integer('provider_profile_id')->unsigned();
            $table->foreign('provider_profile_id')->references('id')->on('provider_profiles')->onDelete('cascade');
        });
    }
    
    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down()
    {
        Schema::table('provider_availabilities', function (Blueprint $table) {
            $table->dropForeign(['provider_profile_id']);
        });
        Schema::dropIfExists('provider_availabilities');
    }
}
