<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProviderProfilesTable extends Migration
{
    public function up()
    {
        Schema::create('provider_profiles', function (Blueprint $table) {
            $table->increments('id');
            $table->json('name')->nullable();
            $table->json('details')->nullable();
            $table->json('meta')->nullable();
            $table->string('address')->nullable();
            $table->decimal('longitude', 15, 7)->default(0.0);
            $table->decimal('latitude', 15, 7)->default(0.0);
            $table->boolean('is_verified')->default(config('vtlabs_provider.provider.verify_default', false));
            $table->decimal('fee', 8, 2)->unsigned()->default(0.0);
            $table->integer('plan_sort_order')->unsigned()->default(100);

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('provider_profiles_categories', function (Blueprint $table) {
            $table->integer('provider_profile_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->foreign('provider_profile_id')->references('id')->on('provider_profiles')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on(config('vtlabs_category.tables.category'))->onDelete('cascade');
            $table->decimal('fee', 8, 2)->unsigned()->default(0.0);
        });

        Schema::create('provider_profiles_subcategories', function (Blueprint $table) {
            $table->integer('provider_profile_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->foreign('provider_profile_id')->references('id')->on('provider_profiles')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on(config('vtlabs_category.tables.category'))->onDelete('cascade');
            $table->decimal('fee', 8, 2)->unsigned()->default(0.0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('provider_profiles_categories', function (Blueprint $table) {
            $table->dropForeign(['provider_profile_id']);
            $table->dropForeign(['category_id']);
        });
        Schema::dropIfExists('provider_profiles_categories');

        Schema::table('provider_profiles_subcategories', function (Blueprint $table) {
            $table->dropForeign(['provider_profile_id']);
            $table->dropForeign(['category_id']);
        });
        Schema::dropIfExists('provider_profiles_subcategories');

        Schema::table('provider_profiles', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('provider_profiles');
    }
}
