<?php

namespace Vtlabs\Payment\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class PaymentMethod extends Model implements HasMedia
{
    use Filterable, HasTranslations, CoreHasMediaTrait;

    protected $table = 'payment_methods';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'meta' => 'array'
    ];

    public $translatable = ['title'];

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
}
