<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Payment\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('paymentmethods', 'PaymentMethodController');
        });
    });

    Route::prefix('payment')->group(function () {

        Route::get('methods', 'PaymentController@paymentMethods');

        Route::post('generic/{payment}/failed', 'PaymentController@failedPayment');

        // Route::get('stripe/{payment}', 'PaymentController@makeStripePayment');
        Route::get('stripe/{payment}', 'PaymentController@makeStripePayment')->name('payment.stripe');
        Route::get('stripe/{payment}/callback', 'PaymentController@callbackStripePayment')->name('payment.stripe.callback');
        Route::get('stripe/{payment}/status', 'PaymentController@statusStripePayment')->name('payment.stripe.status');

        Route::post('payu/{payment}', 'PaymentController@makePayuPayment');

        Route::get('paystack/callback/{payment}', 'PaymentController@paystackCallback');
        Route::get('paystack/status/{payment}', 'PaymentController@paystackStatus');
        Route::get('paystack/{payment}', 'PaymentController@makePaystackPayment');

        Route::get('wallet/{payment}', 'PaymentController@makeWalletPayment');

        Route::post('authorize-net/{payment}', 'PaymentController@makeAuthorizeNetPayment');

        Route::post('bambora/{payment}', 'PaymentController@makeBamboraPayment');

        Route::get('telebirr/callback/{payment}', 'PaymentController@telebirrCallback');
        Route::get('telebirr/status/{payment}', 'PaymentController@telebirrStatus');
        Route::get('telebirr/{payment}', 'PaymentController@makeTelebirrPayment');

        Route::GET('esewa/{payment}/callback', 'PaymentController@esewaCallback');
        Route::GET('esewa/status/{payment}', 'PaymentController@esewaStatus');

        Route::post('razorpay/{payment}/create-order', 'PaymentController@razorpayCreateOrder');
        Route::post('razorpay/{payment}/verify', 'PaymentController@razorpayVerifyOrder');
        Route::post('razorpay/{payment}/failed', 'PaymentController@razorpayFailedPayment');

        Route::post('digipay/callback/{payment}', 'PaymentController@digipayCallback');
        Route::get('digipay/status/{payment}', 'PaymentController@digipayStatus');
        Route::get('digipay/{payment}', 'PaymentController@makeDigipayPayment');

        Route::post('nexi/{payment}/callback', 'PaymentController@nexiCallback')->name('payment.nexi.callback');
        Route::get('nexi/status/{payment}', 'PaymentController@nexiStatus')->name('payment.nexi.status');

        Route::get('payfast/{payment}/form', 'PaymentController@payfastPaymentForm');
        Route::get('payfast/{payment}/callback', 'PaymentController@payfastPaymentCallback')->name('payment.payfast.callback');
        Route::get('payfast/status/{payment}', 'PaymentController@payfastStatus')->name('payment.payfast.status');

        Route::get('viva/{payment}', 'PaymentController@makeVivawalletPayment');
        Route::get('viva/{payment}/callback', 'PaymentController@callbackVivawallet');

        Route::get('safirimpesa/{payment}', 'PaymentController@makeSafirimpesaPayment');
        Route::post('safirimpesa/{payment}/callback', 'PaymentController@safirimpesaCallback')->name('payment.safirimpesa.callback');

        Route::get('paiementpro/{payment}', 'PaymentController@makePaiementproPayment');
        Route::get('paiementpro/{payment}/callback', 'PaymentController@paiementproCallback')->name('payment.paiementpro.callback');
        Route::get('paiementpro/status/{payment}', 'PaymentController@paiementproStatus')->name('payment.paiementpro.status');
    });
});
