<?php

namespace Vtlabs\Media\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;

class News extends Model implements HasMedia
{
    use Filterable,
        HasTranslations,
        CoreHasMediaTrait;

    protected $table = 'news';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public $availableMediaConversions = [];

    public $with = ['media'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public $translatable = ['title'];
}
