<?php

namespace Vtlabs\Media\Models;

use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;

class MediaContent extends Model implements HasMedia
{
    use CoreHasMediaTrait;
    
    protected $table = 'media_content';

    protected $guarded = [];

    protected $casts = [
        'source' => 'array',
        'meta' => 'array',
    ];

    protected $with = ['media'];

    public function parentMedia()
    {
        return $this->belongsTo(config('vtlabs_media.models.media'), 'media_id');
    }
}
