<?php

namespace Vtlabs\Media\Listeners;

use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Media\Models\MediaOrder;
use Vtlabs\Payment\Events\OnWalletPayment;
use Vtlabs\Media\Http\Resources\Media\MediaOrderResource;

class OnWalletPaymentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  OnWalletPayment $event
     * @return void
     */
    public function handle(OnWalletPayment $event)
    {
        $payment = $event->payment;

        if ($payment->payable_type == 'Vtlabs\Media\Models\MediaOrder' && $payment->status == 'paid') {
            $mediaOrder = MediaOrder::find($payment->payable_id);
            $user = User::find($payment->payer_id);

            $user->withdraw($payment->amount, 'withdraw', [
                'description' => $mediaOrder->media->title,
                'type' => 'wallet_payment',
                'source_title' => $mediaOrder->media->title,
                'source' => 'media',
                'source_id' => $mediaOrder->media->id,
                'source_amount' => $mediaOrder->total,
                'source_payment_type' => $mediaOrder->payment->paymentMethod->title,
                'source_data' => new MediaOrderResource($mediaOrder)
            ]);
        }
    }
}
