<?php

namespace Vtlabs\Media\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Vtlabs\Media\Models\Media;
use Vtlabs\Media\Filters\MediaFilter;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class ProcessOverduePosts implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct() {}

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        $activeMedias = Media::filter(['active' => 1], MediaFilter::class)->latest()->get();

        foreach($activeMedias as $activeMedia) {
            $maxDuration = $activeMedia->category->max_duration ?? -1;

            if($maxDuration > 0) {
                $createdAt = $activeMedia->created_at;
                $expirationDate = $createdAt->addDays($maxDuration);
                $now = Carbon::now();
                $hasExpired = $now->greaterThan($expirationDate);

                if($hasExpired) {
                    $activeMedia->setStatus('overdue');
                }
            }
        }
    }
}
