<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Illuminate\Http\Resources\Json\JsonResource;

class NewsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'meta' => $this->meta,
            'sort_order' => $this->sort_order,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'created_at' => $this->created_at->format('Y-m-d H:i:s')
        ];
    }
}