<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Models\User\User;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Category\Http\Resources\CategoryResource;
use Vtlabs\Core\Http\Resources\UserSummaryResource;

class MediaResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),
            'meta' => $this->meta,
            'status' => $this->status,
            'medialibrary' => $this->getMediaUrlsAttribute(),
            'content' => MediaContentResource::collection($this->content),
            'user' => new UserSummaryResource($this->user),
            'category' => new CategoryResource($this->category),
            'subcategories' => CategoryResource::collection($this->subcategories),
            'assignor_id' => $this->assignor_id,
            'assignor' => new UserSummaryResource($this->assignor),
            'assignee_id' => $this->assignee_id,
            'assignee' => new UserSummaryResource($this->assignee),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite,
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
            'likes_count' => $this->likers()->count(),
            'is_liked' => Auth::check() ? Auth::user()->hasLiked(Media::find($this->id)) : false,
            'comments_count' => $this->comments()->count(),
            'views_count' => $this->views_count,
            'shares_count' => $this->shares_count,
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'is_public' => $this->is_public,
            'quickbase_id' => $this->quickbase_id,
            'admin_id' => $this->admin_id,
            'admin' => new UserSummaryResource($this->admin),

            'after_assets_url_1' => $this->after_assets_url_1,
            'after_assets_url_2' => $this->after_assets_url_2,
            'after_assets_url_3' => $this->after_assets_url_3,
        ];
    }
}