<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Core\Models\User\User;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Media\Models\UserAuthorPreference;
use Illuminate\Http\Resources\Json\JsonResource;

class AuthorResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'meta' => $this->meta,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'media_count' => $this->media_count,
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite,
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
            'is_preferred' => Auth::check() ? UserAuthorPreference::where('author_id', $this->id)->where('user_id', Auth::id())->exists() : false,
            'preferred_count' => UserAuthorPreference::where('author_id', $this->id)->count()
            
        ];
    }
}