<?php

namespace Vtlabs\Media\Http\Resources\Media\Admin;

use Kreait\Firebase\Util\JSON;
use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Media\Http\Resources\Media\MediaResource;

class ReportedMediaAdminResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'reason' => $this->reason,
            'reporter' => new UserResource(User::find($this->reporter_id)),
            'reportable' => new MediaResource(Media::find($this->reportable_id)),
            'created_at' => $this->created_at
        ];
    }
}
