<?php

namespace Vtlabs\Media\Http\Controllers\Api;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Vtlabs\Media\Models\Playlist;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Media\Filters\PlaylistFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Media\Http\Resources\Media\MediaResource;
use Vtlabs\Media\Http\Resources\Media\PlaylistResource;

class PlaylistController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([]);

        $request->merge([
            'user_id' => Auth::id()
        ]);

        $playlists = Playlist::filter($request->all(), PlaylistFilter::class)->latest();

        return PlaylistResource::collection($playlists->paginate());
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required'
        ]);

        $playlist = Playlist::create([
            'title' => $request->title,
            'user_id' => Auth::id()
        ]);

        return new PlaylistResource($playlist->fresh());
    }

    public function listMedia(Playlist $playlist, Request $request)
    {
        return MediaResource::collection($playlist->medias()->paginate());
    }

    public function addMedia(Playlist $playlist, Request $request)
    {
        $request->validate([
            'media_id' => 'required|exists:media,id'
        ]);

        if($playlist->medias()->where('id', $request->media_id)->exists()) {
            // remove media from playlist
            $playlist->medias()->detach($request->media_id);
        } else {
            // add media to playlist
            $playlist->medias()->attach($request->media_id, ['created_at' => Carbon::now()]);
        }

        return response()->json((object)[], 200);
    }

    public function destroy(Playlist $playlist)
    {
        $playlist->delete();

        return response()->json((object)[], 200);
    }
}
