<?php

namespace Vtlabs\Media\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Media\Models\News;
use Vtlabs\Media\Filters\NewsFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Media\Http\Resources\Media\NewsResource;

class NewsController extends Controller
{
    
    public function index(Request $request)
    {
        $request->validate([]);

        $news = News::filter($request->all(), NewsFilter::class);

        return NewsResource::collection($news->get());
    }
}
