<?php

namespace Vtlabs\Media\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Media\Http\Resources\Media\Admin\MediaAdminResource;

class QuickbaseController extends Controller
{
    private function checkIsSuperAdmin()
    {
        return Auth::user()->hasRole('superadmin');
    }

    public function postFromQuickbase(Request $request)
    {
        if(!$this->checkIsSuperAdmin()) {
            return response()->json(["message" => 'Only superadmin can access this']);
        }

        $request->validate([
            'title' => 'required',
            'category_id' => 'required|exists:categories,id',
            'address' => 'required',
            'longitude' => 'required',
            'latitude' => 'required',
            'status' => 'required|in:open,reviewed,assigned,started,complete,overdue',
            'user_id' => 'required|exists:users,id',
            'assignor_id' => 'sometimes|exists:users,id',
            'assignee_id' => 'sometimes|exists:users,id',
            'quickbase_id' => 'required',
            'image_urls' => 'sometimes|array',
            'action' => 'required|in:create,update',
            'is_public' => 'required|numeric|min:0|max:1'
        ]);

        request()->merge([
                "meta" => ['type' => 'post']
            ]);

        if($request->action == 'create') {
            $media = new Media();
        } else {
            $media = Media::where('quickbase_id', $request->quickbase_id)->firstOrFail();
        }

        CoreHelper::fillTranslation($media, $request->only(['title']));

        $media = $media->fill($request->only([
            'category_id', 'user_id', 'address', 'longitude', 'latitude', 'assignor_id', 'assignee_id', 'meta', 'is_public', 'quickbase_id'
        ]));

        $media->save();

        $media->setStatus($request->status);

        // images
        if (!empty($request->image_urls)) {
            foreach ($request->image_urls as $image) {
                $media->addMediaFromUrl($image)->toMediaCollection("images");
            }
        }

        return new MediaAdminResource($media->fresh());
    }
}
