<?php

namespace Vtlabs\Media\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Media\Models\Media;
use Vtlabs\Media\Models\Comment;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Media\Filters\CommentFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Media\Http\Resources\Media\Admin\CommentAdminResource;

class CommentController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'media_id' => 'sometimes|exists:media,id',
            'admin' => 'sometimes|exists:users,id'
        ]);

        $comments = Comment::filter($request->all(), CommentFilter::class);

        if($request->media_id) {
            $comments = $comments->where('commentable_id', $request->media_id);
        }

        return CommentAdminResource::collection($comments->orderByDesc('created_at')->paginate());
    }

    public function destroy($id)
    {
        Gate::authorize('delete');

        Comment::find($id)->delete();

        return response()->json([], 200);
    }
}
