<?php

namespace Vtlabs\Media\Helpers;

use Illuminate\Support\Facades\Auth;

class MediaHelper
{
    public static function isAdmin()
    {
        return (Auth::user() && (Auth::user()->hasRole(['admin', 'superadmin', 'supervisor'])));
    }

    public static function isSupervisor()
    {
        return (Auth::user() && (Auth::user()->hasRole(['supervisor'])));
    }


    public static function supervisorCategoryIds()
    {
        return (self::isSupervisor()) ? Auth::user()->categories->pluck('id')->toArray() : [];
    }
}