<?php

namespace Vtlabs\Media\Filters;

use EloquentFilter\ModelFilter;

class NewsFilter extends ModelFilter
{
    public function setup()
    {
        // sorting
        if ($this->input('_sort') && $this->input('_order')) {
            $this->orderBy($this->input('_sort'), $this->input('_order'));
        } else {
            $this->orderBy('sort_order', 'desc');
        }
    }

    public function admin($admin)
    {
        return $this->where('admin_id', $admin);
    }
}
