<?php

namespace Vtlabs\Media\Filters;

use EloquentFilter\ModelFilter;

class CommentFilter extends ModelFilter
{
    public function setup()
    {
        // sorting
        if ($this->input('_sort') && $this->input('_order')) {
            $sortColumn = $this->input('_sort');
            $sortOrder = $this->input('_order');
            if(in_array($sortColumn, ['id', 'comment', 'commentable_id', 'created_at'])) {
                $this->orderBy($sortColumn, $sortOrder);
            } else {
                $this->latest();
            }
        } else {
            $this->latest();
        }
    }

    public function comment($comment)
    {
        return $this->whereLike('comment', $comment);
    }

    public function user($id)
    {
        return $this->whereHas('commentator', function ($query) use ($id) {
            return $query->where('name', 'like', '%' . $id . '%')
                ->orWhere('mobile_number', 'like', '%' . $id . '%')
                ->orWhere('email', 'like', '%' . $id . '%')
                ->orWhere('id', $id);
        });
    }

    public function commentable($commentable)
    {
        return $this->where('commentable_id', $commentable);
    }

    public function created_at($created_at)
    {
        return $this->whereDate('created_at', $created_at);
    }

    public function admin($admin)
    {
        return $this->related('commentable', 'admin_id', '=', $admin);
    }
}
