<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlaylistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('playlists', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('media_playlists', function (Blueprint $table) {
            $table->integer('media_id')->unsigned();
            $table->integer('playlist_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade');
            $table->foreign('playlist_id')->references('id')->on('playlists')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('media_playlists', function (Blueprint $table) {
            $table->dropForeign(['media_id']);
            $table->dropForeign(['playlist_id']);
        });

        Schema::dropIfExists('media_playlists');
        
        Schema::table('playlists', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('playlists');
    }
}
