<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediaOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('media_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();

            $table->double('subtotal', 8,2);
            $table->double('taxes', 8,2);
            $table->double('total', 8,2);
            $table->double('discount', 8,2);

            // media
            $table->integer('media_id')->unsigned()->nullable();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade');
            
            // customer
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('media_orders', function (Blueprint $table) {
            $table->dropForeign(['media_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('media_orders');
    }
}
