<?php

namespace Vtlabs\Media\Models;

use EloquentFilter\Filterable;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class MediaOrder extends Model implements Payable
{
    use CanBePaid, Filterable;
    
    protected $table = 'media_orders';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'array',
        'subtotal' => 'float',
        'taxes' => 'float',
        'total' => 'float',
        'discount' => 'float',
    ];

    public function scopeOrdered($query)
    {
        return $query->orderBy('created_at', 'desc');
    }

    public function media()
    {
        return $this->belongsTo(config('vtlabs_media.models.media'));
    }

    public function user()
    {
        return $this->belongsTo(config('auth.models.user'));
    }
}
